# JFrog Artifactory Reverse Proxy Settings using Nginx

#### Reverse Proxy
*   To use Artifactory as docker registry it's mandatory to use Reverse Proxy.
*   Artifactory provides a Reverse Proxy Configuration Generator screen in which you can fill in a set of fields to generate 
the required configuration snippet which you can then download and install directly in the corresponding directory of your reverse proxy server.   
*   To learn about configuring NGINX or Apache for reverse proxy refer to documentation provided on [JFrog wiki](https://www.jfrog.com/confluence/display/RTF/Configuring+a+Reverse+Proxy)
*   By default Artifactory helm chart uses Nginx for reverse proxy and load balancing.
  
**Note**: Nginx image distributed with Artifactory helm chart is custom image managed and maintained by JFrog.  
  
####  Features of Artifactory Nginx
*   Provides default configuration with self signed SSL certificate.
*   Auto update reverse proxy configuration by pulling configuration generated by Reverse Proxy Configuration Generator from Artifactory using [REST API](https://www.jfrog.com/confluence/display/RTF/Configuring+a+Reverse+Proxy#ConfiguringaReverseProxy-RESTAPI)
*   Persist configuration and SSL certificate in `/var/opt/jfrog/nginx` directory
  
#### Steps to use Reverse Proxy Configuration Generator to configuration for reverse proxy in nginx (Artifactory Pro/Enterprise).  
*   Deploy Artifactory using helm chart with Nginx enabled.
*   Go to Artifactory Admin -> HTTP Settings. 
    Example values: 
    ```
    Docker Access Method: SubDomain
    Server Provider: Nginx
    Internal Hostname: $ARTIFACTORY_SERVICE_NAME (Get Artifactory Service Name by running `kubectl get svc` command)
    Public Server Name: $DOMAIN_NAME
    SSL Key Path: /var/opt/jfrog/nginx/ssl/tls.key (If SSL Cert is provided via Secret)
    SSL Certificate Path: /var/opt/jfrog/nginx/ssl/tls.crt (If SSL Cert is provided via Secret)
    ```
*   Provide appropriate values and save configuration.
*   Once configuration is saved Nginx will automatically fetch reverse proxy configuration snippet from Artifactory and apply it immediately.
  
#### Steps to use static configuration for reverse proxy in nginx.
1.  Create `artifactory-ha.conf` file with nginx configuration. More [nginx configuration examples](https://github.com/jfrog/artifactory-docker-examples/tree/master/files/nginx/conf.d) 
    * Following is example `artifactory-ha.conf`
    ```bash
    ## add HA entries when ha is configure
    upstream artifactory {
        server artifactory-ha-artifactory-ha-primary:8081;
        server artifactory-ha:8081;
    }
    ## add ssl entries when https has been set in config
    ssl_certificate      /var/opt/jfrog/nginx/ssl/tls.crt;
    ssl_certificate_key  /var/opt/jfrog/nginx/ssl/tls.key;
    ssl_session_cache shared:SSL:1m;
    ssl_prefer_server_ciphers   on;
    ## server configuration
    server {
        listen 443 ssl;
        listen 80 ;
        server_name ~(?<repo>.+)\.jfrog.team jfrog.team;
        
        if ($http_x_forwarded_proto = '') {
            set $http_x_forwarded_proto  $scheme;
        }
        ## Application specific logs
        ## access_log /var/log/nginx/jfrog.team-access.log timing;
        ## error_log /var/log/nginx/jfrog.team-error.log;
        rewrite ^/$ /artifactory/webapp/ redirect;
        rewrite ^/artifactory/?(/webapp)?$ /artifactory/webapp/ redirect;
        rewrite ^/(v1|v2)/(.*) /artifactory/api/docker/$repo/$1/$2;
        chunked_transfer_encoding on;
        client_max_body_size 0;
        location /artifactory/ {
        proxy_read_timeout  900;
        proxy_pass_header   Server;
        proxy_cookie_path   ~*^/.* /;
        if ( $request_uri ~ ^/artifactory/(.*)$ ) {
            proxy_pass          http://artifactory/artifactory/$1;
        }
        proxy_pass          http://artifactory/artifactory/;
        proxy_next_upstream http_503 non_idempotent;
        proxy_set_header    X-Artifactory-Override-Base-Url $http_x_forwarded_proto://$host:$server_port/artifactory;
        proxy_set_header    X-Forwarded-Port  $server_port;
        proxy_set_header    X-Forwarded-Proto $http_x_forwarded_proto;
        proxy_set_header    Host              $http_host;
        proxy_set_header    X-Forwarded-For   $proxy_add_x_forwarded_for;
        }
    }
    ```
    
2.  Create configMap of `artifactory-ha.conf` created with step above.
    ```bash
    kubectl create configmap art-nginx-conf --from-file=artifactory-ha.conf
    ```
3.  Deploy Artifactory using helm chart with auto configuration update disabled in nginx.
    You can achieve it by setting value to `true` for `nginx.env.skipAutoConfigUpdate` and providing name of configMap created above to `nginx.customArtifactoryConfigMap` in [values.yaml](values.yaml)
    Which sets Environment Variable `SKIP_AUTO_UPDATE_CONFIG=true` in Nginx container. 
    
    Following is command to set values at runtime:
    ```bash
    helm install --name artifactory-ha --set nginx.env.skipAutoConfigUpdate=true,nginx.customArtifactoryConfigMap=art-nginx-conf jfrog/artifactory-ha
    ```