﻿using Kivii.WebDriver;
using OpenQA.Selenium;
using OpenQA.Selenium.Firefox;
using OpenQA.Selenium.Remote;
using OpenQA.Selenium.Support.Events;
using System;
using System.Threading;
using System.Windows.Forms;

namespace Kivii.Test.WebDriver
{
    public partial class FrmMain : Form
    {
        private Manager _manager=null;
        public FrmMain()
        {
            InitializeComponent();
        }


        private void appendMsg(string msg)
        {
            rtbMsg.AppendText($"{msg}{Environment.NewLine}");
        }

        #region 事件
        private void addListener()
        {
            if (_manager == null) return;

            _manager.OnException += manager_OnException;
            _manager.OnWindowChanged += manager_OnWindowChanged;

            _manager.ElementClicked += EventDriver_ElementClicked;
            _manager.ElementClicking += EventDriver_ElementClicking;
            _manager.ElementValueChanging += EventDriver_ElementValueChanging;
            _manager.ElementValueChanged += EventDriver_ElementValueChanged;
            _manager.ExceptionThrown += EventDriver_ExceptionThrown;
            _manager.FindElementCompleted += EventDriver_FindElementCompleted;
            _manager.FindingElement += EventDriver_FindingElement;
            _manager.GetShadowRootCompleted += EventDriver_GetShadowRootCompleted;
            _manager.GettingShadowRoot += EventDriver_GettingShadowRoot;
            _manager.Navigated += EventDriver_Navigated;
            _manager.NavigatedBack += EventDriver_NavigatedBack;
            _manager.NavigatedForward += EventDriver_NavigatedForward;
            _manager.Navigating += EventDriver_Navigating;
            _manager.NavigatingBack += EventDriver_NavigatingBack;
            _manager.NavigatingForward += EventDriver_NavigatingForward;
            _manager.ScriptExecuted += EventDriver_ScriptExecuted;
            _manager.ScriptExecuting += EventDriver_ScriptExecuting;
        }

        private void manager_OnWindowChanged(object sender, Window e)
        {
            gbMsg.Text = $"输出(窗口Handle={e.Handle},Title={e.Title})";
        }

        private void manager_OnException(object sender, Exception e)
        {
            appendMsg($"Exception:{DateTime.Now}{Environment.NewLine}{e.Message}{Environment.NewLine}{e.StackTrace}");
        }

        private void EventDriver_ScriptExecuting(object sender, WebDriverScriptEventArgs e)
        {
            appendMsg($"EventDriver_ScriptExecuting:{Environment.NewLine}{e.Script}");
        }

        private void EventDriver_ScriptExecuted(object sender, WebDriverScriptEventArgs e)
        {
            appendMsg($"EventDriver_ScriptExecuted:{Environment.NewLine}{e.Script}");
        }

        private void EventDriver_NavigatingForward(object sender, WebDriverNavigationEventArgs e)
        {
            appendMsg($"EventDriver_NavigatingForward:{Environment.NewLine}{e.Url}");
        }

        private void EventDriver_NavigatingBack(object sender, WebDriverNavigationEventArgs e)
        {
            appendMsg($"EventDriver_NavigatingBack:{Environment.NewLine}{e.Url}");
        }

        private void EventDriver_Navigating(object sender, WebDriverNavigationEventArgs e)
        {
            appendMsg($"EventDriver_Navigating:{Environment.NewLine}{e.Url}");
        }

        private void EventDriver_NavigatedForward(object sender, WebDriverNavigationEventArgs e)
        {
            appendMsg($"EventDriver_NavigatedForward:{Environment.NewLine}{e.Url}");
        }

        private void EventDriver_NavigatedBack(object sender, WebDriverNavigationEventArgs e)
        {
            appendMsg($"EventDriver_NavigatedBack:{Environment.NewLine}{e.Url}");
        }

        private void EventDriver_Navigated(object sender, WebDriverNavigationEventArgs e)
        {
            appendMsg($"EventDriver_Navigated:{Environment.NewLine}{e.Url}");
        }

        private void EventDriver_GettingShadowRoot(object sender, GetShadowRootEventArgs e)
        {
            appendMsg($"EventDriver_GettingShadowRoot:{Environment.NewLine}{e}");
        }

        private void EventDriver_GetShadowRootCompleted(object sender, GetShadowRootEventArgs e)
        {
            appendMsg($"EventDriver_GetShadowRootCompleted:{Environment.NewLine}{e}");
        }

        private void EventDriver_FindingElement(object sender, FindElementEventArgs e)
        {
            appendMsg($"EventDriver_FindingElement:{Environment.NewLine}{e}");
        }

        private void EventDriver_FindElementCompleted(object sender, FindElementEventArgs e)
        {
            appendMsg($"EventDriver_FindElementCompleted:{Environment.NewLine}{e}");
        }

        private void EventDriver_ExceptionThrown(object sender, WebDriverExceptionEventArgs e)
        {
            appendMsg($"EventDriver_ExceptionThrown:{Environment.NewLine}{e}");
        }

        private void EventDriver_ElementValueChanged(object sender, WebElementValueEventArgs e)
        {
            appendMsg($"EventDriver_ElementValueChanged:{Environment.NewLine}{e}");
        }

        private void EventDriver_ElementValueChanging(object sender, WebElementValueEventArgs e)
        {
            appendMsg($"EventDriver_ElementValueChanging:{Environment.NewLine}{e}");
        }

        private void EventDriver_ElementClicking(object sender, WebElementEventArgs e)
        {
            appendMsg($"EventDriver_ElementClicking:{Environment.NewLine}{e}");
        }

        private void EventDriver_ElementClicked(object sender, WebElementEventArgs e)
        {
            appendMsg($"EventDriver_ElementClicked:{Environment.NewLine}{e}");
        }
        #endregion

        #region 交互事件
        private void btnOpen_Click(object sender, EventArgs e)
        {
            if (_manager != null) return;
            rtbMsg.Clear();
            _manager = new Manager();
            var serviceUrl = string.Empty;
            if (cbxRemote.Checked)
            {
                if (cbUseHub.Checked)
                {
                    serviceUrl = "http://hub.selenium.kivii.org/";
                }
                else
                {
                    serviceUrl = $"http://driver.{cbxBrowserType.Text}.selenium.kivii.org";
                }
            }
            _manager.Initialize(cbxBrowserType.Text, serviceUrl);
            addListener();
        }
        private void btnClose_Click(object sender, EventArgs e)
        {
            _manager?.Dispose();
            _manager = null;
        }

        private void btnScreenshot_Click(object sender, EventArgs e)
        {
            //if (_driver == null) return;
            SaveFileDialog sfd=new SaveFileDialog();
            sfd.Filter = "图片文件|*.jpg";
            if (sfd.ShowDialog() != DialogResult.OK) return;
            _manager?.Screenshot(sfd.FileName);
        }

        private void btnInjectionScript_Click(object sender, EventArgs e)
        {
            _manager?.LoadScript(tbxScriptPath.Text);
        }

        private void cbxRemote_CheckedChanged(object sender, EventArgs e)
        {
            lnkVncUrl.Enabled = cbxRemote.Checked;
            cbUseHub.Enabled=cbxRemote.Checked;
            cbxBrowserType_SelectedIndexChanged(null, null);
        }
        private void cbxBrowserType_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (!cbxRemote.Checked)
            {
                lnkVncUrl.Text= null;
                return;
            }
            if (cbUseHub.Checked)
            {
                lnkVncUrl.Text = $"http://hub.selenium.kivii.org";
            }
            else
            {
                if (string.IsNullOrEmpty(cbxBrowserType.Text))
                {
                    lnkVncUrl.Text = null;
                }
                else
                {
                    lnkVncUrl.Text = $"http://viewer.{cbxBrowserType.Text}.selenium.kivii.org";
                }
            }
        }
        private void lnkVncUrl_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (cbUseHub.Checked)
            {
                System.Diagnostics.Process.Start($"{lnkVncUrl.Text}");
            }
            else
            {
                System.Diagnostics.Process.Start($"{lnkVncUrl.Text}/?autoconnect=1&resize=scale&password=secret");
            }
        }

        private void btnNavigate_Click(object sender, EventArgs e)
        {
            _manager?.NavigateTo(tbxUrl.Text);
        }
        private void btnExecuteScript_Click(object sender, EventArgs e)
        {
            if (tabScripts.SelectedTab.Tag.ToString() == "engine")//网页内执行
            {
                var result = _manager.Execute(rtbEngineScript.Text);
                rtbEngineScript.Clear();
                appendMsg($"Result:{result}");
            }
            else if (tabScripts.SelectedTab.Tag.ToString() == "web")
            {
                var result = _manager?.ExecuteScript(rtbWebScript.Text);
                rtbWebScript.Clear();
                appendMsg($"Result:{result}");
            }
        }

        private void btnHandlers_Click(object sender, EventArgs e)
        {
            foreach (var handler in _manager.AllWindowHandles)
            {
                appendMsg($"Handler Name:{handler}");
            }
        }

        private void btnClearMsg_Click(object sender, EventArgs e)
        {
            rtbMsg.Clear();
        }

        private void btnAutoAppendScript_Click(object sender, EventArgs e)
        {
            rtbEngineScript.AppendText($"{cbScriptTip.Text}{Environment.NewLine}");
        }
        #endregion



        private void btnTest_Click(object sender, EventArgs e)
        {
            RemoteWebDriver driver = null;
            try
            {
                driver = new RemoteWebDriver(new FirefoxOptions().ToCapabilities());
                //System.Diagnostics.Process.Start($"http://viewer.firefox.selenium.kivii.org/?autoconnect=1&resize=scale&password=secret");
                //driver.Navigate().GoToUrl("https://www.baidu.com");
                driver.ExecuteScript("console.log(1);");
                driver.ExecuteScript("document.getElementByTagName('head');");
                driver.ExecuteScript("alert('1')", "");
            }
            catch (Exception ex)
            {
                appendMsg($"Ex:{Environment.NewLine}{ex.Message}");
            }
            driver.Quit();
        }
    }
}
