﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using Kivii.Rfid.D500;

namespace Test
{
    internal partial class RFIDWritering : Form
    {
        #region 属性

        private Reader _reader = new Reader();
        public string EPC = "";
        public string Title = "等待写卡";
        /// <summary>
        /// 写卡计时器
        /// </summary>
        System.Timers.Timer _tmr = new System.Timers.Timer();
        /// <summary>
        /// 写卡次数，超过一定次数，退出
        /// </summary>
        private int _waitTimes = 0;
        /// <summary>
        /// 等待写空卡次数，超过就跳出
        /// </summary>
        public int WaitTimes { get; set; }

        private int _writeTimes = 0;
        /// <summary>
        /// 写卡次数
        /// </summary>
        public int WriteTimes { get; set; }
        /// <summary>
        /// 写卡密码
        /// </summary>
        public string AccessPassword { get; set; }
        private ProgramEpcParams _accessd = null;
        private ProgramEpcParams accessd
        {
            get
            {
                if (_accessd != null) return _accessd;
                _accessd = new ProgramEpcParams();
                _accessd.NewEpc = EPC;
                _accessd.AntennaPortNumber = 0;
                _accessd.AccessPassword = AccessPassword;
                return _accessd;

            }
        }

        #endregion
        public RFIDWritering(string epc)
        {
            EPC = epc;
            InitializeComponent();
        }

        private void RFIDWritering_Load(object sender, EventArgs e)
        {
            _tmr.Interval = 500;
            _tmr.Elapsed += new System.Timers.ElapsedEventHandler(tmr_Elapsed);
            _reader.Connected += new EventHandler<ConnectionChangedEventArgs>(reader_Connected);
            lblMsg.Text = "初始化中";
            lblOutput.Text = "等待连接RFID终端...";
            List<string> readers = _reader.GetReaderList();
            if (readers.Count <= 0)
            {
                lblMsg.Text = "初始化失败";
                lblMsg.ForeColor = Color.Red;
                lblOutput.Text = "未能连接RFID读写终端,请检查连接线！";
                return;
            }
            else
            {
                lblOutput.Text = "正在连接RFID读写终端...";
                _reader.Connect(readers[0]);
            }

        }
        void reader_Connected(object sender, ConnectionChangedEventArgs e)
        {
            this.Invoke(new Action(delegate()
            {
                lblMsg.Text = Title;
                lblOutput.Text = "连接RFID读写终端成功,等待放入RFID卡片...";
            }));
            _tmr.Start();
        }
        void tmr_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            try
            {
                _tmr.Stop();

                this.Invoke(new Action(delegate() { lblMsg.ForeColor = lblMsg.ForeColor == Color.Black ? Color.Red : Color.Black; }));
                
                _waitTimes += 1;
                
                if (_waitTimes > WaitTimes || _writeTimes >= WriteTimes)
                {
                    this.Invoke(new Action(delegate()
                    {
                        lblOutput.Text = "等待退出程序,关闭RFID读写终端连接中...";
                        this.Close();
                    }));

                    return;
                }
                
                ProgramEpcResult result = _reader.ProgramEpc(accessd);
                if (result.WriteResult.Result == AccessResult.Success)
                {
                    this.Invoke(new Action(delegate()
                    {
                        lblOutput.Text = "写入数据成功,正在验证写入结果...";
                        lblOutput.ForeColor = Color.Green;
                    }));

                    Thread.Sleep(100);

                    ReadEpcResult writeResult = _reader.ReadEpc();
                    if (writeResult.ReadResult.Result!=AccessResult.Success||writeResult.TagAccessed.Epc.ToLower() != EPC.ToLower())
                    {
                        this.Invoke(new Action(delegate()
                        {
                            lblOutput.Text = DateTime.Now.ToString("[HH:mm:ss]") + "写入数据失败,尝试重写数据中...";
                            lblOutput.ForeColor = Color.Red;
                        }));
                        throw new Exception();
                    }

                    _waitTimes = 0;
                    _writeTimes += 1;

                    this.Invoke(new Action(delegate()
                    {
                        lblOutput.Text = "验证写入数据成功...";
                        lblOutput.ForeColor = Color.Blue;
                    }));
                    Thread.Sleep(200);

                    this.Invoke(new Action(delegate()
                    {
                        lblOutput.Text = "等待放入RFID卡片...";
                        lblOutput.ForeColor = Color.Black;
                    }));
                }
                else
                {
                    this.Invoke(new Action(delegate()
                    {
                        lblOutput.Text = "等待放入RFID卡片...";
                        lblOutput.ForeColor = Color.Black;
                    }));
                }
            }
            catch
            {
            }
            finally
            {
            }
            GC.Collect();
            if(_tmr!=null)_tmr.Start();
        }


        protected override void OnClosing(CancelEventArgs e)
        {
            try
            {
                _tmr.Elapsed -= new System.Timers.ElapsedEventHandler(tmr_Elapsed);
                _reader.Connected -= new EventHandler<ConnectionChangedEventArgs>(reader_Connected);
                _tmr.Stop();
                _tmr.Dispose();
                _reader.DisConnect();
                _reader = null;
            }
            catch { }
            base.OnClosing(e);
        }

    }
}
