﻿using Kivii.Rfid.D500;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Test
{
    public partial class FrmMain : Form
    {
        private Reader _reader = null;

        public FrmMain()
        {
            InitializeComponent();
        }
        private void FrmMain_Load(object sender, EventArgs e)
        {
            _reader = new Reader();
            _reader.Connected += reader_Connected;
            _reader.ConnectionLost += reader_ConnectionLost;
            _reader.Disconnected += reader_Disconnected;
            _reader.TagsReported += reader_TagsReported;
        }

        private void reader_TagsReported(object sender, TagsReportedEventArgs e)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action(delegate () { reader_TagsReported(sender, e); }));
                return;
            }
            rtbMessage.AppendText("reader_TagsReported:EPC"+e.tag.epc + Environment.NewLine);
        }

        private void reader_ConnectionLost(object sender, ConnectionChangedEventArgs e)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action(delegate (){ reader_ConnectionLost(sender, e); }));
                return;
            }
            rtbMessage.AppendText("reader_ConnectionLost:" + Environment.NewLine);
        }

        private void reader_Disconnected(object sender, ConnectionChangedEventArgs e)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action(delegate () { reader_Disconnected(sender, e); }));
                return;
            }
            rtbMessage.AppendText("reader_Disconnected:" + Environment.NewLine);
        }

        private void reader_Connected(object sender, ConnectionChangedEventArgs e)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action(delegate () { reader_Connected(sender, e); }));
                return;
            }
            rtbMessage.AppendText("reader_Connected:" + Environment.NewLine);
        }

        private void btnReadDeviceList_Click(object sender, EventArgs e)
        {
            rtbMessage.AppendText("设备列表:"+string.Join(",", _reader.GetReaderList())+Environment.NewLine);
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            var devices = _reader.GetReaderList();
            if (devices == null || devices.Count == 0)
            {
                rtbMessage.AppendText("未找到设备" + Environment.NewLine);
                return;
            }
            if (_reader.State == ApplicationConnectionState.Connected) return;
            _reader.Connect(devices[0]);
        }

        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            if (_reader.State != ApplicationConnectionState.Connected) return;
            _reader.DisConnect();
        }

        private void btnReadEPC_Click(object sender, EventArgs e)
        {
            if (_reader.State != ApplicationConnectionState.Connected) return;
            try
            {
                ReadEpcResult result = _reader.ReadEpc();
                if (result.ReadResult.Result == AccessResult.Success)
                {
                    rtbMessage.AppendText($"EPC:{result.TagAccessed.Epc}{Environment.NewLine}");

                }
            }
            catch (Exception ex)
            {
                var o = "";
            }
        }

        private void btnReadTID_Click(object sender, EventArgs e)
        {
            if (_reader.State != ApplicationConnectionState.Connected) return;
            ReadTidMemoryParams accessd = new ReadTidMemoryParams();
            accessd.WordCount = 6;
            ReadTidMemoryResult result = _reader.ReadTidMemory(accessd);
            if (result.ReadResult.Result == AccessResult.Success)
            {
                rtbMessage.AppendText($"TID:{result.ReadResult.ReadData}{Environment.NewLine}");
            }
        }

        private void btnWriteEPC_Click(object sender, EventArgs e)
        {
            var accessd = new ProgramEpcParams();
            accessd.NewEpc = tbxEPC.Text;
            accessd.AntennaPortNumber = 0;
            accessd.AccessPassword = "00000000";
            ProgramEpcResult result = _reader.ProgramEpc(accessd);
            if (result.WriteResult.Result == AccessResult.Success)
            {
                rtbMessage.AppendText($"写EPC成功:{accessd.NewEpc}{Environment.NewLine}");
            }


        }

        private void btnListen_Click(object sender, EventArgs e)
        {
            if (_reader.State != ApplicationConnectionState.Connected) return;
            if (btnListen.Tag == null)
            {
                btnListen.Text = "停止监听";
                btnListen.Tag = true;
                _reader.Start();
            }
            else
            {
                btnListen.Text = "开始监听";
                btnListen.Tag = null;
                _reader.Stop();
            }
        }
    }
}
