﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Kivii.Pdf.Test
{
    public partial class frmMain : Form
    {
        public frmMain()
        {
            InitializeComponent();
        }

        private void btnSelectFile_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Pdf文件|*.pdf";
            if (ofd.ShowDialog() != DialogResult.OK) return;
            tbxPdfFilePath.Text = ofd.FileName;
        }

        private void btnSelectStamp_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "图片|*.png;*.jpg;*.gif";
            if (ofd.ShowDialog() != DialogResult.OK) return;
            tbxStampFilePath.Text = ofd.FileName;

        }

        private void btnSelectPfx_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "数字证书|*.pfx";
            if (ofd.ShowDialog() != DialogResult.OK) return;
            tbxSignatureFilePath.Text = ofd.FileName;
        }

        private void btnSelectSaveFilePath_Click(object sender, EventArgs e)
        {
            SaveFileDialog sfd = new SaveFileDialog();
            sfd.Filter = "Pdf文件|*.pdf";
            if (sfd.ShowDialog() != DialogResult.OK) return;
            tbxSaveFilePath.Text = sfd.FileName;

        }

        private StampSetting getSetting()
        {
            try
            {
                var rtns = new StampSetting();
                rtns.StampFilePath = tbxStampFilePath.Text;
                rtns.StampWidth = tbxStampWidth.Text;
                rtns.Pages = tbxPages.Text;
                rtns.OffsetX = tbxOffsetX.Text;
                rtns.OffsetY = tbxOffsetY.Text;
                rtns.MatchText = tbxMatchText.Text;
                rtns.SignatureFilePath = tbxSignatureFilePath.Text;
                rtns.SignatureFilePassword = tbxSignatureFilePassword.Text;
                rtns.SignatureReason = tbxSignatureReason.Text;
                rtns.SignatureLocation = tbxSignatureLocation.Text;
                rtns.SignatureTimeStampAuthorityUrl = tbxSignatureTimeStampAuthorityUrl.Text;

                rtns.StampType = (StampType)Enum.Parse(typeof(StampType), cbxStampType.Text.Split('-')[0]);
                return rtns;
            }
            catch
            {
                return null;
            }

        }
        private void btnStamp_Click(object sender, EventArgs e)
        {
            var setting = getSetting();
            if (setting == null)
            {
                MessageBox.Show("参数设置有误");
                return;
            }
            PdfReader reader = null;
            if (tbxPdfFilePath.Text.StartsWith("http", StringComparison.CurrentCultureIgnoreCase))
            {
                reader = new PdfReader(new Uri(tbxPdfFilePath.Text));
            }
            else
            {
                reader = new PdfReader(tbxPdfFilePath.Text);
            }
            try
            {
                var result = reader.Stamp(setting, tbxSaveFilePath.Text);
                reader.Close();
                MessageBox.Show($"操作结果:{result}");
            }
            catch (Exception ex)
            {
                MessageBox.Show($"发生错误:{ex.Message}");
            }
        }
    }
}
