﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kivii.Client.Test.Forms
{
    public partial class FrmMain : Form
    {
        private JsonServiceClient _client;
        public FrmMain()
        {
            InitializeComponent();
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            btnLogin.Enabled = false;
            _client = new JsonServiceClient(tbxServiceUrl.Text);
            _client.Timeout = TimeSpan.FromSeconds(20);
            var loginRequest = new Authenticate {UserName=tbxUserName.Text,Password=tbxPassword.Text,provider="Kivii" };
            var tasks=_client.PostAsync(loginRequest);
            tasks.Success(resp => {
                btnLogin.Enabled = resp.DisplayName.IsNullOrEmpty();
                btnLogout.Enabled = !btnLogin.Enabled;
                tbxDisplayName.Text = resp.DisplayName;
            });
            tasks.Error(ex => {
                btnLogin.Enabled = true;
                MessageBox.Show(ex.Message, "Login Error");
            });
           
        }

        private void btnLogout_Click(object sender, EventArgs e)
        {
            if (_client == null) return;
            btnLogout.Enabled = false;
            var logoutRequest = new Authenticate {provider = "Logout" };

            var tasks = _client.PostAsync(logoutRequest);
            tasks.Success(resp => {
                btnLogin.Enabled = resp!=null;
                btnLogout.Enabled = !btnLogin.Enabled;
                tbxDisplayName.Text = "";
                _client.Dispose();
                _client = null;
            });
            tasks.Error(ex => {
                btnLogout.Enabled = true;
                MessageBox.Show(ex.Message, "Logout Error");
            });
        }
    }
}
