﻿using Kivii.Organizations.Entities;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Kivii.Linq;

namespace Kivii.Client.Test.Forms
{
    public partial class FrmMain : Form
    {
        private JsonServiceClient _client;
        public FrmMain()
        {
            InitializeComponent();
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            btnLogin.Enabled = false;
            //创建一个Json数据通讯格式的客户端
            _client = new JsonServiceClient(tbxServiceUrl.Text);
            //设置请求超时
            _client.Timeout = TimeSpan.FromSeconds(20);
            //定义一个身份认证数据包
            var loginRequest = new Authenticate {UserName=tbxUserName.Text,Password=tbxPassword.Text,provider="Kivii" };
            //通过异步的方式POST数据到服务器
            var tasks=_client.PostAsync(loginRequest);
            //当成功获取到数据后，异步执行以下的代码
            tasks.Success(resp => {
                btnLogin.Enabled = resp.DisplayName.IsNullOrEmpty();
                btnLogout.Enabled = !btnLogin.Enabled;
                tbxDisplayName.Text = resp.DisplayName;
            });
            //当执行错误后，执行以下的代码
            tasks.Error(ex => {
                btnLogin.Enabled = true;
                MessageBox.Show(ex.Message, "Login Error");
            });
           
        }

        private void btnLogout_Click(object sender, EventArgs e)
        {
            if (_client == null) return;
            btnLogout.Enabled = false;
            //使当前的_client的身份退出。
            var logoutRequest = new Authenticate {provider = "Logout" };

            var tasks = _client.PostAsync(logoutRequest);
            tasks.Success(resp => {
                btnLogin.Enabled = resp!=null;
                btnLogout.Enabled = !btnLogin.Enabled;
                tbxDisplayName.Text = "";
                _client.Dispose();
                _client = null;
            });
            tasks.Error(ex => {
                btnLogout.Enabled = true;
                MessageBox.Show(ex.Message, "Logout Error");
            });
        }

        private void btnQueryMember_Click(object sender, EventArgs e)
        {
            if (_client == null) return;
            dgvResults.DataSource = null;
            var queryMember = new MemberQuery();
            queryMember.FullNameContains = tbxFullNameContains.Text;
            queryMember.FirstNameIn = tbxFirstNameIn.Text;
            var tasks = _client.PostAsync(queryMember);
            tasks.Success(resp => {
                dgvResults.DataSource = resp.Results;
            });
            tasks.Error(ex => {
                var x = "";

            });
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            var results=dgvResults.DataSource as List<Member>;
            if (results == null||results.Count==0) return;
            var conn = KiviiContext.GetOpenedDbConnection<Member>();
            foreach (var member in results)
            {
                if (conn.Exists<Member>(o => o.Kvid == member.Kvid)) continue;
                conn.Insert(member);
            }
        }
    }
}
