﻿using Kivii.DataAnnotations;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
/// <summary>
/// 服务器上的实体，注意，类名称空间最好和服务器上一样，否则需要自己定义路由信息
/// </summary>
namespace Kivii.Organizations.Entities
{
    [Alias("Members")]
    //类中的属性不一定要全，需要多少属性就写多少属性
    public class Member:EntityWithMetadata
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string DisplayName { get; set; }

        public DateTime BirthDate { get; set; }
        public string FullName { get; set; }
    }

    //这个就是和服务器上类似的Transform,因为Member的类名称为 Kivii.Organizations.Entities.Member,和服务器一致，所以不需要额外配置路由
    public class MemberQuery : RestfulQuery<Member>
    {
        //查询参数，属性+标记 Contains代表包含，即like匹配
        public string FullNameContains { get; set; }

        //In代表一个数组，用逗号隔开
        public string FirstNameIn { get; set; }

        ////大于
        //public DateTime BirthDateGreaterThan { get; set; }
        //public DateTime BirthDateGreaterThanOrEqualsTo { get; set; }
        ////小于
        //public DateTime BirthDateLessThan { get; set; }
        ////小于等于
        //public DateTime BirthDateLessThanOrEqualsTo { get; set; }

        ////介于两个之间
        //public string StatusBetween { get; set; }
    }
}
