﻿using Kivii;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Test
{
    public partial class FrmMain : Form
    {
        ServerEventsClient _client = null;
        public FrmMain()
        {
            InitializeComponent();
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            if (_client != null)//断开操作
            {
                _client.Stop();
                _client.Dispose();
                _client = null;
                btnConnect.Text = "连接";
                return;
            }
            //连接操作
            btnConnect.Enabled=false;
            _client = new ServerEventsClient(tbxServiceUrl.Text);
            var auth = new Authenticate { UserName =tbxUserName.Text, Password = tbxPassword.Text, provider = "kivii" };
            var task=_client.ServiceClient.PostAsync(auth);
            task.Success(()=>{
                //登陆成功后连接ServerEvents，设置事件
                _client.OnConnect = onConnected;
                _client.OnCommand = onCommand;
                _client.OnMessage = onMessage;
                _client.OnException = onException;
                _client.OnHeartbeat = onHeartbeat;
                _client.Connect();
            }, true);
            task.Error((ex)=> {
                btnConnect.Enabled = true;
                _client.Dispose();
                _client = null;
                rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:Exception {ex.Message}{Environment.NewLine}{Environment.NewLine}");
                rtbMessage.ScrollToCaret();
            }, true);

        }
        //连接成功，得到连接相应的信息
        private void onConnected(ServerEventConnect connection)
        {
            if (InvokeRequired)
            {
                Invoke(new Action(() => onConnected(connection)));
                return;
            }
            btnConnect.Enabled = true;
            btnConnect.Text = "断开";
            tbxFullName.Text = connection.DisplayName;
            tbxSubscriptionId.Text = connection.Id;
            tbxChannels.Text = connection.Channels?.Join(",");

            tbxConnectedTime.Text = DateTime.Now.ToString("HH:mm:ss");
            tbxConnectedTime.BackColor = tbxConnectedTime.BackColor != Color.MistyRose ? Color.MistyRose : Color.YellowGreen;

            rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:onConnect {connection.Json}{Environment.NewLine}{Environment.NewLine}");
            rtbMessage.ScrollToCaret();
        }
        //得到心跳包
        private void onHeartbeat()
        {
            if (InvokeRequired)
            {
                Invoke(new Action(onHeartbeat));
                return;
            }
            tbxHeartBeatTime.BackColor = tbxHeartBeatTime.BackColor != Color.MistyRose ? Color.MistyRose : Color.YellowGreen;
            tbxHeartBeatTime.Text = DateTime.Now.ToString("HH:mm:ss");
        }
        //出现异常
        private void onException(Exception ex)
        {
            if (InvokeRequired)
            {
                Invoke(new Action(()=>onException(ex)));
                return;
            }
            rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:onException {ex.Message}{Environment.NewLine}{Environment.NewLine}");
            rtbMessage.ScrollToCaret();
        }
        //得到消息
        private void onMessage(ServerEventMessage message)
        {
            if (InvokeRequired)
            {
                Invoke(new Action(() => onMessage(message)));
                return;
            }
            rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:onMessage {message.Json}{Environment.NewLine}{Environment.NewLine}");
            rtbMessage.ScrollToCaret();
        }
        //得到命令
        private void onCommand(ServerEventMessage command)
        {
            if (InvokeRequired)
            {
                Invoke(new Action(() => onCommand(command)));
                return;
            }
            var eventUpdate = command as ServerEventUpdate;
            if (eventUpdate!=null&&eventUpdate.SubscriptionId==_client.ConnectionInfo.SubscriptionId)
            {
                tbxChannels.Text = eventUpdate.Channels.Join(",");
            }
            rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:{command.GetType().Name} {command.Json}{Environment.NewLine}{Environment.NewLine}");
            rtbMessage.ScrollToCaret();
        }



        private void btnSendMessage_Click(object sender, EventArgs e)
        {
        }

        private void btnGet_Click(object sender, EventArgs e)
        {
            var users = _client.GetChannelSubscribers();
            var id = _client.SubscriptionId;
        }

        private void btnRemoveChannel_Click(object sender, EventArgs e)
        {
            btnRemoveChannel.Enabled = false;
            var task=_client.UnsubscribeFromChannelsAsync(tbxUpdateChannel.Text.Split(new char[1] { ',' }, StringSplitOptions.RemoveEmptyEntries));
            task.Success(()=>{
                btnRemoveChannel.Enabled = true;
            });
            task.Error((ex)=> {
                btnRemoveChannel.Enabled = true;
                rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:onException {ex.Message}{Environment.NewLine}{Environment.NewLine}");
                rtbMessage.ScrollToCaret();
            });

        }

        private void btnAddChannel_Click(object sender, EventArgs e)
        {
            btnAddChannel.Enabled = false;
            var task = _client.SubscribeToChannelsAsync(tbxUpdateChannel.Text.Split(new char[1] { ',' }, StringSplitOptions.RemoveEmptyEntries));
            task.Success(() => {
                btnAddChannel.Enabled = true;
            });
            task.Error((ex) => {
                btnAddChannel.Enabled = true;
                rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:onException {ex.Message}{Environment.NewLine}{Environment.NewLine}");
                rtbMessage.ScrollToCaret();
            });

        }

        private void btnGetSubscriptions_Click(object sender, EventArgs e)
        {
            btnGetSubscriptions.Enabled = false;
            var task = _client.GetChannelSubscribersAsync();
            task.Success(() => {
                btnGetSubscriptions.Enabled = true;
                foreach (var item in task.Result)
                {
                    rtbMessage.AppendText($"DisplayName:{item.DisplayName},UserId:{item.UserId},SubscriptionId:{item.SubscriptionId},Channels:{item.Channels.Join()}{Environment.NewLine}");
                    rtbMessage.ScrollToCaret();
                }
            },true);
            task.Error((ex) => {
                btnGetSubscriptions.Enabled = true;
                rtbMessage.AppendText($"{DateTime.Now.ToString("HH:mm:ss")}:onException {ex.Message}{Environment.NewLine}{Environment.NewLine}");
                rtbMessage.ScrollToCaret(); 
            },true);
        }

        private void btnClearDebugMessage_Click(object sender, EventArgs e)
        {
            rtbMessage.Clear();
        }
    }
}
