# Kubeflow

The Kubeflow project is dedicated to making deployments of machine learning (ML) workflows on Kubernetes simple, portable and scalable. Our goal is not to recreate other services, but to provide a straightforward way to deploy best-of-breed open-source systems for ML to diverse infrastructures. Anywhere you are running Kubernetes, you should be able to run Kubeflow

## Who should consider using Kubeflow?

Based on the current functionality you should consider using Kubeflow if:

- You want to train/serve TensorFlow models in different environments (e.g. local, on prem, and cloud)
- You want to use Jupyter notebooks to manage TensorFlow training jobs
- You want to launch training jobs that use resources – such as additional CPUs or GPUs – that aren’t available on your personal computer
- You want to combine TensorFlow with other processes
  > For example, you may want to use [tensorflow/agents](https://github.com/google-research/batch-ppo) to run simulations to generate data for training reinforcement learning models.
